package game;


import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class MarquisSprite {
	private String message;
	private int xPos;
	private int yPos;
	private int ticksOfLife;
	private int xOffset;
	
	private Color firstColor;
	private Color secondColor;
	
	private static final int MAX_TICKS_OF_SOLIDITY = 20;
	private static final int MAX_TICKS_OF_FADING = 10;
	
	public MarquisSprite(String msg, int x, int y, Color c1, Color c2) {
		
		xPos = x;
		yPos = y;
		
		
		xOffset = retrieveOffsetForString(msg);
		
		if(xPos - ((int) (xOffset * 1.2))  < 0)
			xPos = ((int) (xOffset * 1.2));
		
		firstColor = c1;
		secondColor = c2;
		
		message = msg;
		
		ticksOfLife = 0;
		
	}
	
	public void update() {
		

		yPos -= 1;
		
		ticksOfLife++;
		
	}
	
	public void draw(Graphics g, PlayerSprite player, int panelWidth, int panelHeight) {
		
		drawObject(g, panelWidth/2 + (xPos - player.getxPos()) , panelHeight/2 + (yPos - player.getyPos()));
		
	}
	
	private void drawObject(Graphics g, int xDraw, int yDraw) {
		
		Font origFont = g.getFont();
		
		Font newFont = new Font(origFont.getName(), Font.BOLD, 18);
		
		g.setFont(newFont);
		
		Color prevColor = g.getColor();
		
		Color toBeStartedWith = null;
		
		if(ticksOfLife % 2 == 0)
			toBeStartedWith = firstColor;
		else
			toBeStartedWith = secondColor;
		
		Color toBeUsed = null;
		
		if(ticksOfLife <= MAX_TICKS_OF_SOLIDITY) {
			toBeUsed = toBeStartedWith;
		} else {
			toBeUsed = new Color(toBeStartedWith.getRed(),
					             toBeStartedWith.getGreen(),
					             toBeStartedWith.getBlue(),
					             (int) (255.0 - ( 255.0 * ((double)(ticksOfLife - MAX_TICKS_OF_SOLIDITY))/ ((double) MAX_TICKS_OF_FADING))));
		}
		
		g.setColor(toBeUsed);
		
		g.drawString(message, xDraw - xOffset, yDraw);
		
		g.setColor(prevColor);
		g.setFont(origFont);
		
	}
	
	
	public boolean isPastThreshold() {
		return ticksOfLife > MAX_TICKS_OF_SOLIDITY + MAX_TICKS_OF_FADING;
	}
	
	

	public int retrieveWidthOfCharacter(char c) {
		
		
		switch(c) {
		case '|':
			return 3;
		case 'I':
		case '\'':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
			return 4;
		case 'i':
		case 'j':
		case 'l':
		case ' ':
		case '!':
		case '':
		case ',':
		case '-':
		case '.':
		case '[':
		case ']':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
			return 5;
		case 't':
		case '(':
		case ')':
		case '/':
		case '\\':
		case ';':
		case '':
		case '':
		case '':
			return 6;
		case 'r':
		case 'f':
		case '`':
		case '':
		case '{':
		case '}':
		case ':':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
			return 7;
		case '\"':
		case '*':
		case '':
			return 8;
		case 'z':
		case '':
		case '':
			return 9;
		case 'a':
		case 'c':
		case 'e':
		case 'k':
		case 's':
		case 'v':
		case 'x':
		case 'Z':
		case '#':
		case '^':
		case '_':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
		case '0':
			return 10;
		case 'b':
		case 'd':
		case 'g':
		case 'h':
		case 'n':
		case 'o':
		case 'p':
		case 'q':
		case 'u':
		case 'F':
		case 'J':
		case 'L':
		case 'S':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '$':
		case '+':
		case '':
		case '':
		case '':
		case '<':
		case '=':
		case '>':
		case '?':
		case '':
		case '':
		case '':
		case '':
		case '':
		default:
			return 11;
		case 'y':
		case 'E':
		case 'P':
		case 'T':
		case 'U':
		case 'X':
		case 'Y':
		case '':
		case '':
		case '':
		case '~':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
			return 12;
		case 'B':
		case 'C':
		case 'D':
		case 'H':
		case 'N':
		case 'R':
		case 'V':
		case 'K':
		case '&':
		case '':
		case '':
		case '':
		case '':
		case '':
			return 13;
		case 'A':
		case 'G':
		case 'O':
		case 'Q':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
		case '':
			return 14;
		case 'M':
		case '':
			return 15;
		case 'w':
		case '':
		case '':
		case '':
			return 16;
		case 'm':
		case '%':
			return 17;
		case 'W':
		case '@':
			return 18;
		case '':
			return 19;
		case '':
		case '':
			return 20;
		
		}
		
	}
	
	public int retrieveOffsetForString(String inString) {
		
		int tally = 0;
		
		for(int i = 0; i < inString.length(); i++) {
			tally += retrieveWidthOfCharacter(inString.charAt(i));
		}
		
//		System.out.println("\n\n\nabout to return " + (tally / 2) + "for input string <<" + inString + ">>\n\n\n");
		
		return tally / 2;
	}
	
	
}
